// background.js

const DEFAULT_SETTINGS = {
  selectedFields: [
    "description",
    "gla_condition",
    "gla_gender",
    "gla_size",
    "gla_sizeSystem",
    "gla_sizeType",
    "gla_color",
    "gla_material",
    "gla_pattern",
    "gla_ageGroup",
    "gla_multipack",
    "gla_isBundle",
    "gla_adult",
    "pinterest_condition"
  ],
  fieldTemplates: {
    // description as an array of one static segment by default
    description:
[
  {
    type: 'token',
    value: 'brand_text'
  },
    { type:'static', value:'' },
  {
    type: 'token',
    value: 'garment_subtype'
  },
  {
    type: 'token',
    value: 'garment_type'
  },
  {
    type: 'token',
    value: 'sidedness'
  },
  {
    type: 'token',
    value: 'garment_text'
  },
  {
    type: 'static',
    value: 'Colour:'
  },
  {
    type: 'token',
    value: 'color'
  },
  {
    type: 'static',
    value: 'Size:'
  },
  {
    type: 'token',
    value: 'size'
  }
],
    brand_text: "Jays n Dees",
    gla_condition:      "",
    gla_gender:         "",
    gla_size:           "{size}",
    gla_sizeSystem:     "",
    gla_sizeType:       "",
    gla_color:          "{color}",
    gla_material:           "{material}",
    gla_pattern:           "{pattern}",
    gla_ageGroup:       "",
    gla_multipack:           "{multipack}",
    gla_isBundle:       "",
    gla_adult:          "",
    pinterest_condition:"",
    sidedness:      "single-sided"    // default type
    // We won’t store the areas here; they live under their own key
  },

  garmentTypeDefaults: {
    // high‑level types → their sub‑options
	shirt: ['Unisex Garment-Dyed','Unisex Heavy Cotton','Unisex Softstyle','Adult Staple','Unisex Cotton Crew','Unisex Ultra Cotton','Mens Heavy Oversized','Unisex Heavy Faded','Organic Staple','Unisex Faded','Unisex Jersey Short Sleeve','Unisex Jersey Short Sleeve V-Neck','Unisex Tri-Blend Crew','Unisex Oversized Boxy','Unisex Moisture Wicking','Unisex Cut & Sew','Unisex CVC Jersey','Unisex Jersey','Beefy-T Short Sleeve','Unisex Classic','Unisex Creator 2.0','Mens Sport Polo','Unisex Garment-Dyed Heavyweight Cotton','Unisex Cotton Ringer','Unisex Color Blast','Mens Sports Jersey','Unisex Garment-Dyed Pocket','Unisex Polo','Mens Hawaiian','Spiral Tie-Dye','Unisex Urban Heavy','Mens Baseball Jersey','Unisex Zone Performance','Unisex Heavy Cotton Pocket','Unisex adidas Performance Polo','Unisex Garment-Dyed Drop Shoulder','Unisex HD Cotton','Cyclone Tie-Dye','Mens Hawaiian Camp','Unisex Heavy Oversize','Mens Pique Polo','Mens Polyester','Under Armour Mens Polo (Embroidery)','Unisex Triblend','Mens Single Jersey','Champion','USA-Made Unisex Short Sleeve Jersey','Mens Loose','Mens Performance','Mens Baseball Jersey','Mens Staple Ringer','Mens Lightweight Fashion','Organic Unisex Classic','Unisex Mineral Wash','Crystal Tie-Dye','Mens Acid Washed Heavy Oversize','Mens Recycled Organic','Unisex Pocket','Unisex Freestyler Dry Handfeel Heavy','Unisex Ultra Heavy Cotton Box','Mens Fine Jersey','Unisex adidas Sport','Mens Fitted V-Neck Short Sleeve','Mens Very Important','Unisex Hammer','Unisex US Made Midweight','Mens Heavyweight','Unisex Classic Jersey','Unisex Deluxe','Unisex Long Body Urban','Acid Washed Round Neck','Mens Jersey Curved Hem','Mens Short Sleeve','Unisex Long Sleeve','Unisex Classic Crewneck','Unisex Hawaiian','Unisex Sueded','Single Jersey','Mens Modern-fit','Unisex FWD Fashion Tie-Dyed','Unisex ComfortWash Garment-Dyed','Oversized Tie-Dye (Embroidery)','Unisex Ultra Cotton Tall','Short-Sleeved for Men','Mens Heavy Faded Long Sleeve','Mens Staple Faded','Mens Raglan','Mens T-Shirt','Mens Basic','Core Cotton','Mens Presenter V-neck','Mens Staple V Neck','Unisex Iconic','Mens Lightweight V-Neck','Mens Sports','Womens Midweight Cotton Tee','Womens Crop Tee','The Boyfriend Tee for Women','Womens Maple Tee','Womens Boxy Tee','Womens Softstyle Tee','Womens Festival Crop Top','Womens Favorite Tee','Ladies V-Neck T-Shirt','Womens Cotton Tee','Champion Womens Heritage Cropped T-Shirt','Womens Baby Tee','Womens Sports Jersey','Womens Cut & Sew Tee','Organic Rib Baby Tee','Womens Flow Cropped Tee','Crop Tee','Ladies Competitor Tee','Womens Triblend Tee','Single Jersey Womens T-shirt','Womens Short Pajama Set','Womens Heavy Faded Crop Tee','Womens Baseball Jersey','Womens Tie-Dye Crop Tee','Womens Performance V-Neck T-Shirt','Organic Womens Classic T-Shirt','Womens Short Sleeve Shirt','Womens Organic Boxy T-shirt','Womens Organic Short Sleeve T-Shirt','Core Cotton Tee','Womens Iconic T-Shirt','Ladies Cotton T-Shirt','Womens T-Shirt','Womens Jersey Short Sleeve Deep V-Neck Tee','Youth Short Sleeve Tee','Toddler Short Sleeve Tee','Toddlers Fine Jersey Tee','Kids Heavy Cotton Tee','Youth Midweight Tee','Kids Softstyle Tee','Kids Fine Jersey Tee','Heavy Cotton Toddler T-shirt','Youth Competitor Tee','Kids Sports Jersey','Kids Jersey Tank Top','Toddler T-shirt','Softstyle','Heavy Cotton','Ultra Cotton','Jersey'],

	hoodie: ['Unisex Heavy Blend Full Zip Hooded Sweatshirt','Unisex Midweight Softstyle Fleece Hoodie','Unisex Supply Hoodie','Unisex Heavy Blend Hooded Sweatshirt','Three-Panel Fleece Hoodie','Unisex College Hoodie','Unisex Garment-Dyed Hoodie','Champion Hoodie','Unisex Zip Hoodie','Mens NUBLEND Hooded Sweatshirt','Unisex Lightweight Hooded Sweatshirt','Unisex Sponge Fleece Pullover Hoodie','Unisex Hooded Sweatshirt','Unisex Pullover Hoodie','Unisex EcoSmart Pullover Hoodie Sweatshirt','Fashion Hoodie','Athletic Hoodie','King Hooded Sweatshirt','Unisex Full Zip Hoodie','Relaxed Hoodie','Unisex adidas Fleece Hoodie','Unisex Hooded Long Sleeve Tee','Unisex Cruiser 2.0 Hoodie','Unisex DryBlend Hooded Sweatshirt','Unisex Fleece Zip Up Hoodie','Unisex Hooded Zip Sweatshirt','Unisex US Made Hooded Sweatshirt','Unisex Hooded Blanket','Mens Full Zip Hoodie','Mens Organic Hoodie','Unisex Eco Raglan Hoodie (Embroidery)','Unisex Champion Tie-Dye Hoodie (Embroidery)','Unisex Fleece Hoodie','Mens Hoodie','Unisex Pigment-Dyed Hoodie (Embroidery)','Unisex Varsity Hoodie','Unisex Sider Hoodie','Womens Cropped Hooded Sweatshirt','Womens Cinched Bottom Hoodie','Crop Hoodie','Womens Hoodie Dress','Girlie College Hoodie','Womens Full-Zip Hoodie','Womens Organic Relaxed Fit Hoodie','Womens Hooded Blanket','Unisex French Terry Hoodie'],

	sweatshirt: ['Unisex Garment-Dyed Sweatshirt','Unisex Lightweight Crewneck Sweatshirt','Unisex Crewneck Sweatshirt','Unisex Heavy Blend Crewneck Sweatshirt','Unisex Midweight Softstyle Fleece Crewneck Sweatshirt','Unisex Sweatshirt','Unisex NuBlend Crewneck Sweatshirt','Champion Sweatshirt','Unisex adidas Fleece Crewneck Sweatshirt','Quarter-Zip adidas Pullover (Embroidery)','Unisex ComfortWash Garment Dyed Crewneck Sweatshirt','Unisex Drop Shoulder Sweatshirt','Unisex Urban Crewneck Sweatshirt','Unisex Columbia Fleece Jacket (Embroidery)','Nantucket Crewneck Sweatshirt','Unisex DryBlend Crewneck Sweatshirt','Unisex EcoSmart Crewneck Sweatshirt','Unisex Color Blast Crewneck Sweatshirt','Mens Champion Crewneck Sweatshirt','Unisex Supply Crew Sweatshirt','Unisex Crew Neck Sweatshirt (EU)','Unisex Crew Sweatshirt','Unisex Tie-Dye Sweatshirt','Lightweight Sweatshirt','Mens Crewneck Long Sleeve Sweatshirt','Mens Organic Sweatshirt','Mens Crewneck Sweatshirt','Womens Cropped Fleece Pullover','Womens Cropped Sweatshirt','Womens Crewneck Sweatshirt','Unisex French Terry Raglan Crewneck','Youth Heavy Blend Hooded Sweatshirt','Youth Crewneck Sweatshirt','Toddler Pullover Fleece Hoodie','Kids Hoodie','Youth Heavy Blend Zipped Hoodie','Toddler Sweatshirt','Childrens Hoodie','Kids Sweatshirt','Softstyle Youth Midweight Hooded Sweatshirt','Toddler Pullover Fleece Hoodies','Kids Fleece Hoodie (Embroidery)','Kids Relax Hoodie'],

	longsleeve: ['Mens Base Longsleeve','Unisex Garment-dyed Long Sleeve','Three-Panel Fleece Hoodie','Unisex Ultra Cotton Long Sleeve','Unisex Lightweight Crewneck Sweatshirt','Unisex Crewneck Sweatshirt','Unisex Jersey Long Sleeve','Unisex Lightweight Long Sleeve','Champion Hoodie','Mens Sports Warmup Hoodie','Unisex Zip Hoodie','Unisex Quarter-Zip Pullover','Mens Long Sleeve Shirt','Unisex 3/4 Sleeve Baseball Tee','Mens UV Protection Long Sleeve','Mens Bomber Jacket','Unisex Pullover Hoodie','Champion Sweatshirt','Unisex Heavyweight Letterman Jacket','Mens Puffer Jacket','Unisex Tri-Blend 3/4 Raglan Tee','Unisex Performance Long Sleeve','Unisex Hooded Long Sleeve','Mens Denim Jacket','Champion Unisex Packable Anorak Jacket','Unisex Three-Quarter Sleeve Raglan','Windbreaker Jacket','Unisex Hooded Zip Sweatshirt','Unisex Flannel Shirt','Unisex Classic Long Sleeve','Unisex Long Sleeve','Unisex Long Sleeve Pocket','Unisex EcoSmart Crewneck Sweatshirt','Unisex Denim Jacket (Embroidery)','Long Sleeve Crewneck','Mens Champion Crewneck Sweatshirt','Unisex ComfortWash Garment-Dyed Long Sleeve','Mens Long Sleeve Crew','Unisex Champion Tie-Dye Hoodie (Embroidery)','Mens Heavy Faded Long Sleeve','Mens Pajama Set','Ladies Quarter-Zip Pullover','Womens Denim Jacket','Womens Cropped Hoodie','Womens Bomber Jacket','Womens Cropped Sweatshirt','Windbreaker Jacket','Womens Long Sleeve V-neck Shirt','Womens Long Sleeve Dance Dress','Womens Satin Pajamas','Womans Puffer Jacket','Womans Full-Zip Hoodie','Womens Varsity Jacket','Infant Long Sleeve Bodysuit','Toddler Long Sleeve Tee','Youth Long Sleeve Competitor Tee'],

	tanktop: ['Unisex Barnard Tank','Unisex Jersey Tank','Unisex Garment-Dyed Tank Top','Unisex Stonewash Tank Top','Unisex Heavy Cotton Tank Top','Basketball Jersey','Mens Softstyle Tank Top','Unisex Tank Top','Mens Tank','Unisex Softstyle Tank Top','Womens Ideal Racerback Tank','Womens Micro Rib Racer Tank Top','Womens Spaghetti Strap Tank Top','Womens Flowy Scoop Muscle Tank','Womens Tri-Blend Racerback Tank','Womens Flowy Racerback Tank','Organic Rib Baby Tee','Tie Dye Racerback Tank Top','Womens Tank Top','Womens Micro Ribbed Tank','Womens Baby Rib Tank','Womens Sporty Racerback Tank'],

	sportswear: ['Unisex Moisture Wicking Tee','Mens Sport Polo Shirt','Unisex Lightweight Long Sleeve Tee','Basketball Jersey','Mens Sports Warmup Hoodie','Mens Sports Jersey','Unisex Quarter-Zip Pullover','Mens Baseball Jersey','Unisex Zone Performance T-shirt','adidas Unisex Performance Polo','Athletic Joggers','Unisex Football Jersey','Under Armour Mens Polo Shirt (Embroidery)','Mens UV Protecting Long Sleeve Shirt','Mens Mesh Sneakers','Mens Performance T-Shirt','Basketball Shorts','adidas Unisex Fleece Crewneck Sweatshirt','Basketball Rib Shorts','adidas Quarter-Zip Pullover (Embroidery)','adidas Unisex Fleece Hoodie','Unisex Performance Long Sleeve Shirt','adidas Unisex Fleece Joggers','Mens Board Shorts','Unisex Basketball Jersey','adidas Unisex Sport T-shirt','Unisex Garment-Dyed Fleece Sweatpants','Unisex Garment-Dyed Fleece Sweat Shorts','Mens Sports Shorts','Mens Jogger Shorts','Athletic Long Shorts','Mens Sports T-shirt','Womens Casual Leggings','High Waisted Yoga Leggings','Womens Sports Jersey','Sports Bra','Ladies Quarter-Zip Pullover','Ladies Competitor Tee','Womens Relaxed Shorts','Womens Mesh Sneakers','Womens Baseball Jersey','Womens Workout Shorts','Womens Performance V-Neck T-Shirt','Womens Casual Shorts','Womens Sport Racerback Tank','Womens Bike Shorts','Polyester Sports Bra','Womens Capri Leggings','Plus Size Leggings','Womens Mid-rise Casual Leggings','Womens Polyester Yoga Shorts','Womens Yoga Pants','Youth Competitor Tee','Youth Long Sleeve Competitor Tee','Youth Joggers','Kids Sports Jersey','Kids Leggings','Youth Leggings'],

	bottom: ['Swim Trunks','Athletic Joggers','Basketball Shorts','Mens Mid Length Swim Shorts','Mens Pajama Pants','Basketball Rib Shorts','Mens Boxers','adidas Unisex Fleece Joggers','Mens Board Shorts','Unisex Garment-Dyed Fleece Sweatpants','Unisex Garment-Dyed Lightweight Fleece Sweat Shorts','Mens Sports Shorts','Mens Boxer Briefs','Mens Jogger Shorts','Unisex Swim Shorts','Mens Elastic Beach Shorts','Mens Pajama Set','Womens Cut & Sew Casual Leggings','High Waisted Yoga Leggings','Womens Pajama Pants','Womens Casual Leggings','Athletic Joggers','Womens Thongs','Stretchy Leggings','Womens Pajama Pants','Womens Underwear','Womens Shorts','Unisex Garment-Dyed Fleece Sweatpants','Unisex Garment-Dyed Lightweight Fleece Sweat Shorts','adidas Unisex Fleece Joggers','Womens Short Pajama Set','Basketball Rib Shorts','Womens Relaxed Shorts','Unisex Swim Shorts','Womens Workout Shorts','Womens Biker Shorts','Womens Casual Shorts','Womens Briefs','Womens Capri Leggings','Womens Satin Pajamas','Womens Casual Spandex Leggings','Womens Bike Shorts','Womens Capri Leggings','Plus Size Leggings','Womens Mid-rise Casual Leggings','Womens Polyester Yoga Shorts','Womens Yoga Pants','Kids Lounge Pants','Youth Joggers','Kids Leggings','Youth Leggings'],

	swimwear: ['Swim Trunks','Mens Board Shorts','Unisex Swim Shorts','Mens Mid-Length Swim Shorts','Mens Elastic Beach Shorts','Womens Bikini Swimsuit','Womens One-piece Swimsuit','Unisex Swim Shorts','Womens Vintage Swimsuit','Womens Classic One-Piece Swimsuit'],

	shoe: ['EVA Foam Rubber Shoes','Mens Mesh Sneakers','Flip Flops','Mens Indoor Slippers','Mens Removable-Strap Sandals','Mens High Top Sneakers','Mens Classic Sneakers','Mens Low Top Sneakers','Mens Slide Sandals','Mens Sneakers','EVA Foam Rubber Shoes','Womens Low Top Sneakers','Flip Flops','Womens Slide Sandals','Womens High Top Sneakers','Womens Mesh Sneakers','Womens Removable-Strap Sandals','Womens Indoor Slippers','Womens Classic Sneakers','Womens Sneakers','Kids EVA Foam Clogs','Youth Removable-Strap Sandals'],

	skirtdress: ['T-Shirt Dress','Womens Skater Skirt','Womens Skater Dress','Long Sleeve Kimono Robe','Womens Cut & Sew Racerback Dress','Womens Pencil Skirt','Womens Long Sleeve Dance Dress','Womens Racerback Dress','Womens Mid-Waist Pencil Skirt','Womens Hoodie Dress','Girls Sleeveless Sundress'],

	baby: ['Infant Fine Jersey Bodysuit','Infant Fine Jersey Tee','Infant Baby Rib Bodysuit','Baby Short Sleeve Bodysuit','Infant Jersey One Piece','Baby Short Sleeve Onesie','Baby Organic Short Sleeve Bodysuit','Infant Long Sleeve Bodysuit','Baby T-Shirt','Baby Short Sleeve T-Shirt','Baby Contrast Trim Jersey Bib','Toddler Long Sleeve Tee','Baby Long-Sleeve Organic Bodysuit','Short Sleeve Baby Bodysuit','Toddler T-shirt','Onesie Organic Baby Bodysuit','Infant Cotton Jersey Tee','Combed Cotton Baby Bodysuit'],

	sockwear: ['Sublimination Socks','Recycled Poly Socks','Sublimination Crew Socks','Cushioned Crew Socks','Sublimination Crew Socks (EU)','Crew Socks','Mid-length Socks'],

	hat: ['Trucker Caps','Snapback Trucker Cap','Unisex Distressed Cap','Classic Dad Cap','Dad Hat with Leather Patch (Rectangle)','Vintage Cap (Embroidery)','Bucket Hat','Low Profile Baseball Cap','Surf Cap','Snapback Trucker Cap (Embroidery)','Flat Bill Snapback','Dad Hat with Leather Patch (Round)','Denim Hat (Embroidery)','Vintage Corduroy Cap (Embroidery)','Closed-Back Structured Cap (Embroidery)','Flat Bill Cap (Embroidery)','Distressed Dad Hat (Embroidery)','5 Panel Cap (Embroidery)','Snapback (Embroidery)','Trucker Retro Hat','Organic Baseball Cap (Embroidery)','5 Panel Trucker Cap (Embroidery)','Bucket Hat (Embroidery)','Foam Trucker Hat (Embroidery)','Knit Beanie (Embroidery)','Mesh Cap','Camouflage Trucker Hat (Embroidery)','Classic Cuffed Beanie (Embroidery)','Baby Beanie','Pom-Pom Knit Cap (Embroidery)'],

	underwear: ['Womens Thongs','Mens Boxers','Womens Underwear','Womens Briefs','Mens Boxer Briefs'],

	mask: ['Fabric Face Mask','Fitted Polyester Face Mask','Midweight Neck Gaiter','Lightweight Neck Gaiter','Winter Neck Gaiter with Drawstring','Mixed-Fabric Face Mask','Snug-Fit Polyester Face Mask','Kids Face Mask']
  },

  // initial free‑text for garment_text
  garment_text: '',

  // New key for area selections + labels
  sidednessAreas: {
    // areaCode: { selected: boolean, label: string }
    "None":           { selected: true,  label: "" },
    "All Over Print":    { selected: false, label: "" },
    "Sleeve Left":    { selected: false, label: "" },
    "Sleeve Right":   { selected: false, label: "" },
    "Neck label inner": { selected: false, label: "" }
  },

};

chrome.runtime.onInstalled.addListener(details => {
  if (details.reason === 'install') {
    chrome.storage.local.set({...DEFAULT_SETTINGS, licenceType: 'Lite'}, () => {
      console.log('Bulk Product Variations: Default settings saved.');
    });
  }
});