// Generate browser ID
function generateBrowserId() {
  const ua = navigator.userAgent;
  const platform = navigator.platform;
  const vendor = navigator.vendor;
  const timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
  const lang = navigator.language;
  const seed = ua + platform + vendor + timezone + lang;

  let hash = 0;
  for (let i = 0; i < seed.length; i++) {
    hash = (hash << 5) - hash + seed.charCodeAt(i);
    hash |= 0;
  }
  return 'browser-' + Math.abs(hash).toString(16);
}

// Store browser ID
const browserId = generateBrowserId();
chrome.storage.local.get('browserId', ({ browserId: existing }) => {
  if (!existing) {
    chrome.storage.local.set({ browserId });
    console.log('[BrowserDetect] First-run ID generated:', browserId);
  }
});

// Blur entire page for unsupported browsers
const ua = navigator.userAgent;
if (!/(Firefox|Chrome|Edg|Brave)/.test(ua)) {
  const overlay = document.createElement('div');
  Object.assign(overlay.style, {
    position: 'fixed',
    top: 0,
    left: 0,
    width: '100%',
    height: '100%',
    backdropFilter: 'blur(10px)',
    zIndex: 999999,
    pointerEvents: 'none'
  });
  document.body.appendChild(overlay);
}