export async function getHashDeviceSigning() {
  // Use globalThis to ensure compatibility across background/page scripts
  const nav = globalThis.navigator || {};
  const screen = globalThis.screen || {};

  const baseData = [
    nav.userAgent || '',
    nav.language || '',
    nav.platform || '',
    nav.hardwareConcurrency || '',
    nav.deviceMemory || '',
    screen.colorDepth || '',
    screen.width || '',
    screen.height || '',
    screen.availHeight || '',
    screen.availWidth || '',
    new Date().getTimezoneOffset(),
    Intl.DateTimeFormat().resolvedOptions().timeZone || 'unknown'
  ].join('::');

  const encoder = new TextEncoder();
  const baseBuf = encoder.encode(baseData);

  // Primary hash (deviceId)
  const hashBuf1 = await crypto.subtle.digest('SHA-256', baseBuf);
  const deviceId = [...new Uint8Array(hashBuf1)].map(b => b.toString(16).padStart(2, '0')).join('');

  // Secondary hash (deviceFingerprint)
  const salt = 'SRBv2::fingerprint-salt';
  const hashBuf2 = await crypto.subtle.digest('SHA-256', encoder.encode(baseData + '::' + salt));
  const deviceFingerprint = [...new Uint8Array(hashBuf2)].map(b => b.toString(16).padStart(2, '0')).join('');

  // Basic OS detection
  const ua = (nav.userAgent || '').toLowerCase();
  let os = 'unknown';
  if (ua.includes('windows')) os = 'Windows';
  else if (ua.includes('mac')) os = 'macOS';
  else if (ua.includes('linux')) os = 'Linux';
  else if (ua.includes('android')) os = 'Android';
  else if (ua.includes('iphone') || ua.includes('ipad')) os = 'iOS';

  // Timezone locale
  const timezoneLocale = Intl.DateTimeFormat().resolvedOptions().timeZone || 'unknown';

return {
  deviceId,
  deviceFingerprint,
  os,
  timezoneLocale,
  browserInfo: nav.userAgent || ''
};
}