// register.js

const LITE_CONSTRAINTS = {
  licence_type:         'Lite',
  max_regions_per_page: 3,
  max_pages:            2,
  max_profiles:         1,
  allowed_profiles: false,
  allowed_effects:      ['blur'],
  blur_slider:          false,
  import_export:        false,
  activation_limit:     1,
  screenshot:           false,
  watermark:            true,
  watermark_slider:     false,
  watermark_toggle:     false,
  watermark_opacity_range: [1.0],
  color_picker:         false,
  pixel_able:           false,
  pixel_size:           0
};

const API_BASE = 'https://www.jaysndees.com/extensions/srb_v2043/api';

document.addEventListener('DOMContentLoaded', async () => {
    const registerBtn = document.getElementById('registerNow');
    const emailInput = document.getElementById('emailInput');
    const licenceKeyInput = document.getElementById('licenceKeyInput');
    const messageDiv = document.getElementById('registerMessage');
    const activationsBody = document.getElementById('activationsBody');
    const purchaseField = document.getElementById('purchaseField');
    const purchaseSourceEl = document.getElementById('purchaseSource');
    const purchasedBtn     = document.getElementById('purchasedBtn');

    const { licenceType = 'Lite' } = await chrome.storage.local.get('licenceType');

    if (licenceType === 'Anonymous') {
        purchaseField.classList.add('hidden');
    } else {
        purchaseField.classList.remove('hidden');
    }


// Disable until they pick a source
purchasedBtn.disabled = true;
purchaseSourceEl.addEventListener('change', () => {
  purchasedBtn.disabled = !purchaseSourceEl.value;
});

purchasedBtn.addEventListener('click', () => {
  const src = purchaseSourceEl.value;
  if (src === 'chrome_store') {
    // Redirect them to the web‑store listing so they can click “Buy”
    //function currently DISABLED
    chrome.tabs.create({
      url: 'https://chrome.google.com/webstore/detail/YOUR_EXTENSION_ID'
    });
  } else if (src === 'ecommerce_site') {
    // Send to jaysndees checkout page
    window.open('https://www.jaysndees.com/product/screen-region-blockout-v2/', '_blank');
  }
});

    registerBtn.addEventListener('click', async () => {
        messageDiv.textContent = '';
        const email = emailInput.value.trim();
        const key = licenceKeyInput.value.trim();
        const { deviceId } = await chrome.storage.local.get('deviceId');
        const { browserInfo } = await chrome.storage.local.get('browserInfo');
        const { timezoneLocale } = await chrome.storage.local.get('timezoneLocale');
        const { browserId } = await chrome.storage.local.get('browserId');

        if (!email || !key) {
            messageDiv.textContent = 'Please enter both email and licence key.';
            return;
        }

        const payload = {
            email,
            licence_key: key,
            device_id: deviceId,
            browser_id: browserId,
            device_fingerprint: navigator.userAgent,
            extension_version: chrome.runtime.getManifest().version,
            os: navigator.platform,
            timezone_locale: timezoneLocale,
            browser_info: browserInfo
        };

        try {
            const res = await fetch(`${API_BASE}/activate_licence.php`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload)
            });
            const data = await res.json();
            if (data.success) {
                await chrome.storage.local.set({
                    licenceType: data.licence_type,
                    licenceConstraints: data.constraints,
                    licenceKey: key,
                    email: email
                });
		chrome.runtime.sendMessage({ action: 'updateConstraints' });
		    const { licenceType = 'Lite' } = await chrome.storage.local.get('licenceType');
		    if (licenceType === 'Anonymous') {
        			purchaseField.classList.add('hidden');
    		    } else {
        			purchaseField.classList.remove('hidden');
    		    }

                messageDiv.textContent = 'Licence activated successfully!';
                loadActivations(key);
            } else {
                messageDiv.textContent = data.error || 'Activation failed.';
            }
        } catch (e) {
            console.error(e);
            messageDiv.textContent = 'Network error, please try again.';
        }
    });

    async function loadActivations(key) {
        try {
            const res = await fetch(`${API_BASE}/list_activations.php`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({ licenceKey: key })
            });

    if (res.status === 404) {
      // No endpoint or no activations left
      activationsBody.innerHTML =
        '<tr><td colspan="4">No activations found.</td></tr>';
      return;
    }

    if (!res.ok) {
      throw new Error(`HTTP ${res.status}`);
    }

            const data = await res.json();
            activationsBody.innerHTML = '';
            if (data.success && data.activations.length > 0) {
                data.activations.forEach(act => {
                    const tr = document.createElement('tr');
                    tr.innerHTML = `
                        <td title="${act.browser_id}">${act.browser_id.slice(0,8)}...</td>
                        <td title="${act.device_fingerprint}">${act.device_fingerprint.slice(0,8)}...</td>
                        <td>${act.activated_at.slice(0,10)}</td>
                        <td><button class="revokeBtn" data-browser-id="${act.browser_id}">Revoke</button></td>
                    `;
                    activationsBody.appendChild(tr);
                });

                document.querySelectorAll('.revokeBtn').forEach(btn => {
                    btn.addEventListener('click', async () => {
    const browserId = btn.dataset.browserId;
    const { licenceKey } = await chrome.storage.local.get('licenceKey');

    if (!browserId || !licenceKey) {
      return alert('Missing licenceKey or browserId.');
    }
                        if (!confirm('Revoke this activation?')) return;
                        try {
      console.log('Revoking browserId:', browserId);

                            const resp = await fetch(`${API_BASE}/deactivate_licence.php`, {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                                body: new URLSearchParams({ licenceKey, browserId })
                            });
                            const data = await resp.json();
      console.log('Deactivate response:', data);

                            if (data.success) {
  if (btn.dataset.browserId === browserId) {
    await chrome.storage.local.remove('licenceKey');
    await chrome.storage.local.set({
      licenceType: 'Lite',
      licenceConstraints: LITE_CONSTRAINTS
    });
    await chrome.storage.local.set({
      profiles: ['default'],
      activeProfile: 'default'
    });
    const allData = await chrome.storage.local.get(null);
    const keysToDelete = Object.keys(allData).filter(key => {
      // match keys like "srb_regions_{profile}_{url}"
      if (!key.startsWith('srb_regions_')) return false;
      const [, , profileName] = key.split('_'); 
      return profileName && profileName !== 'default';
    });
    if (keysToDelete.length) {
      await chrome.storage.local.remove(keysToDelete);
    }

    messageDiv.textContent = 'Your licence has been removed — now in Lite mode.';
  } else {
    messageDiv.textContent = 'Activation revoked.';
  }
  await loadActivations(licenceKey);
                            } else {
                                alert('Failed to revoke: ' + (data.error || 'Unknown error.'));
                            }
                        } catch {
      console.error('Network error:', data.error);

                            alert('Network error while revoking.');
                        }
                    });
                });

            } else {
                activationsBody.innerHTML = '<tr><td colspan="4">No activations found.</td></tr>';
            }
        } catch (e) {
            activationsBody.innerHTML = '<tr><td colspan="4">Error loading activations.</td></tr>';
        }
    }

    // Attempt to auto-load activations if licence key exists
    chrome.storage.local.get('licenceKey', (data) => {
        if (data.licenceKey) {
            loadActivations(data.licenceKey);
        } else {
            activationsBody.innerHTML = '<tr><td colspan="4">No licence key stored yet.</td></tr>';
        }
    });
});