function showToast(message, isError = false) {
  // Check if a toast already exists and remove it
  const existingToast = document.getElementById('licence-toast');
  if (existingToast) {
    existingToast.remove();
  }

  const toast = document.createElement('div');
  toast.id = 'licence-toast';
  toast.textContent = message;
  Object.assign(toast.style, {
    position: 'fixed',
    bottom: '20px',
    left: '50%',
    transform: 'translateX(-50%)',
    background: isError ? '#e74c3c' : '#2ecc71',
    backgroundColor: '#323232',
    color: '#fff',
    padding: '10px 20px',
    borderRadius: '4px',
    fontSize: '14px',
    zIndex: 999999,
    boxShadow: '0 2px 10px rgba(0,0,0,0.3)',
    opacity: '0',
    transition: 'opacity 0.3s ease-in-out'
  });

  document.body.appendChild(toast);
  requestAnimationFrame(() => {
    toast.style.opacity = '1';
  });

  setTimeout(() => {
    toast.style.opacity = '0';
    setTimeout(() => toast.remove(), 300);
  }, 3000);
}